<?php

namespace App\Controllers;

use App\Libraries\CIAuth;
use App\Libraries\EmailService;

use App\Models\PanelModel;
use App\Models\TokenCodeModel;
use App\Models\SidebarModel;
use App\Models\WebModel;
use App\Models\SmtpModel;
use App\Models\GalleryModel;

class SettingsController extends BaseController {
    
    public function __construct(){
        $panelModel = new PanelModel();
        $this->settings = $panelModel->getSettings();
    }

    // Settings Panel ----------------------------------------------------------
    public function panel_index(){
        if(!CIAuth::check()){
            return redirect()->to(base_url('ns-admin/login'));
        }
        
        $allowedAdminTypes = [1, 3];
        if(!in_array(CIAuth::adminType(), $allowedAdminTypes)){
            return redirect()->to(base_url('ns-admin'));
        }
        
        $data = [
            'pageTitle' => 'Settings admin panel',
            'currentFile' => 'settings_panel',
        ];
        
        $smtpModel = new SmtpModel();
        $data['row'] = $smtpModel->where('id', 1)->first();
        
        $data['settings'] = $this->settings;
        return view('settings_panel', $data);
    }
    
    public function panelHandler(){
        if(!CIAuth::check()){
            return redirect()->to(base_url('ns-admin/login'));
        }
        
        $allowedAdminTypes = [1, 3];
        if(!in_array(CIAuth::adminType(), $allowedAdminTypes)){
            return redirect()->to(base_url('ns-admin'));
        }
        
        // Simple CSRF check with better error handling
        $postedToken = $this->request->getPost('csrf_test_name');
        if (empty($postedToken)) {
            $message = array('message' => 'CSRF token is missing. Please refresh the page and try again.', 'class' => 'error');
            session()->set('response_msg', $message);
            return redirect()->to(base_url('ns-admin/settings-panel'));
        }
        if ($postedToken !== csrf_hash()) {
            $message = array('message' => 'Security token validation failed. Please refresh the page and try again.', 'class' => 'error');
            session()->set('response_msg', $message);
            return redirect()->to(base_url('ns-admin/settings-panel'));
        }
        
        if ($this->request->getPost('submit_general') !== null) {
            
            $imageName = $this->handleImageUploadAdmin($this->settings['app_logo']);
            
            $data = array(
                'app_name'  =>  $this->request->getPost('app_name'),
                'app_logo'  =>  $imageName,
                'site_description'  =>  $this->request->getPost('site_description'),
                'site_keywords'  =>  $this->request->getPost('site_keywords'),
            );
            
            $panelModel = new PanelModel();
            $panelModel->update('1', $data);
            $message = array('message' => lang('Validation.updated'),'class' => 'success');
            session()->set('response_msg', $message);
            
        } else if ($this->request->getPost('submit_style') !== null) {
            
            $data = array(
                'header_code'  =>  htmlentities(trim($this->request->getPost('header_code'))),
                'footer_code'  => htmlentities(trim($this->request->getPost('footer_code')))
            );
            
            $panelModel = new PanelModel();
            $panelModel->update('1', $data);
            $message = array('message' => lang('Validation.updated'),'class' => 'success');
            session()->set('response_msg', $message);
            
        } else if ($this->request->getPost('submit_rtl') !== null) {
            
            $data = array(
                'site_direction' => ($this->request->getPost('site_direction') !== null && $this->request->getPost('site_direction')) ? '1' : '0'
            );
            
            $panelModel = new PanelModel();
            $panelModel->update('1', $data);
            $message = array('message' => lang('Validation.updated'),'class' => 'success');
            session()->set('response_msg', $message);
        } else if ($this->request->getPost('submit') !== null) {
            
            $key = ($this->request->getPost('smtpIndex') == 'gmail') ? '0' : '1';
            $password = '';
            if ($this->request->getPost('smtp_password')[$key] != '') {
                $password = $this->request->getPost('smtp_password')[$key];
            } else {
                if ($key == 0) {
                    $password = $this->request->getPost('smtp_gpassword');
                } else {
                    $password = $this->request->getPost('smtp_password');
                }
            }
            if ($key == 0) {
                $data = array(
                    'smtp_type'  =>  'gmail',
                    'smtp_ghost'  =>  $this->request->getPost('smtp_host')[$key],
                    'smtp_gemail'  =>  $this->request->getPost('smtp_email')[$key],
                    'smtp_gpassword'  =>  $password,
                    'smtp_gsecure'  =>  $this->request->getPost('smtp_secure')[$key],
                    'gport_no'  =>  $this->request->getPost('port_no')[$key]
                );
            } else {
                $data = array(
                    'smtp_type'  =>  'server',
                    'smtp_host'  =>  $this->request->getPost('smtp_host')[$key],
                    'smtp_email'  =>  $this->request->getPost('smtp_email')[$key],
                    'smtp_password'  =>  $password,
                    'smtp_secure'  =>  $this->request->getPost('smtp_secure')[$key],
                    'port_no'  =>  $this->request->getPost('port_no')[$key]
                );
            }
            
            $smtpModel = new SmtpModel();
            $smtpRecord = $smtpModel->find(1);
            if ($smtpRecord) {
                $smtpModel->update('1', $data);
            } else {
                $smtpModel->insert($data);
            }
            $message = array('message' => lang('Validation.updated'),'class' => 'success');
            session()->set('response_msg', $message);
            
        } else if ($this->request->getPost('btn_send') !== null) {
            
            $email = $this->request->getPost('email');
            
            $emailService = new EmailService();
            $toName   = 'Recipient SMTP Configuration';
            $subject = '[IMPORTANT] '.$this->settings['app_name'].' Check SMTP Configuration';
            $msg  = '<tr>
        		<img src="'.base_url('images/'.$this->settings['app_logo']).'" alt="header" />
        		</br>
        		<h1>Hello!</h1>
        		<p>'.lang('Validation.email_configuration').'</p>
        		<p>Thank you.</p>
        		';
            if ($emailService->sendEmail($email, $toName, $subject, $msg)) {
                $message = array('message' => lang('Validation.email_sent'),'class' => 'success');
            } else {
                $message = array('message' => lang('Validation.email_sent_failed'),'class' => 'error');
            }
            session()->set('response_msg', $message);
        }
        
        else if ($this->request->getPost('submit_recaptcha') !== null) {
            
            $data = array(
                'is_recaptcha' => ($this->request->getPost('is_recaptcha') !== null && $this->request->getPost('is_recaptcha')) ? '1' : '0',
                'recaptcha_site_key'  =>  $this->request->getPost('recaptcha_site_key'),
                'recaptcha_secret_key'  =>  $this->request->getPost('recaptcha_secret_key'),
            );
            
            $panelModel = new PanelModel();
            $panelModel->update('1', $data);
            $message = array('message' => lang('Validation.updated'),'class' => 'success');
            session()->set('response_msg', $message);
        }
        
        return redirect()->to(base_url('ns-admin/settings-panel'));
    }
    
    // Settings App ------------------------------------------------------------
    public function app_index(){
        if(!CIAuth::check()){
            return redirect()->to(base_url('ns-admin/login'));
        }
        
        $allowedAdminTypes = [1, 3];
        if(!in_array(CIAuth::adminType(), $allowedAdminTypes)){
            return redirect()->to(base_url('ns-admin'));
        }
        
        $data = [
            'pageTitle' => 'Settings App',
            'currentFile' => 'settings_app',
        ];
        
        $data['settings'] = $this->settings;
        return view('settings_app', $data);
    }
    
    public function appHandler(){
        if(!CIAuth::check()){
            return redirect()->to(base_url('ns-admin/login'));
        }
        
        $allowedAdminTypes = [1, 3];
        if(!in_array(CIAuth::adminType(), $allowedAdminTypes)){
            return redirect()->to(base_url('ns-admin'));
        }
        
        // Simple CSRF check with better error handling
        $postedToken = $this->request->getPost('csrf_test_name');
        if (empty($postedToken)) {
            $message = array('message' => 'CSRF token is missing. Please refresh the page and try again.', 'class' => 'error');
            session()->set('response_msg', $message);
            return redirect()->to(base_url('ns-admin/settings-app'));
        }
        if ($postedToken !== csrf_hash()) {
            $message = array('message' => 'Security token validation failed. Please refresh the page and try again.', 'class' => 'error');
            session()->set('response_msg', $message);
            return redirect()->to(base_url('ns-admin/settings-app'));
        }
        
        if ($this->request->getPost('submit_general') !== null) {
            
            $data = array(
                'app_email'  =>  $this->request->getPost('app_email'),
                'app_author'  =>  $this->request->getPost('app_author'),
                'app_contact'  =>  $this->request->getPost('app_contact'),
                'app_website'  =>  $this->request->getPost('app_website'),
                'app_developed_by'  =>  $this->request->getPost('app_developed_by'),
                'app_description'  =>  $this->request->getPost('app_description')
            );
            
            $panelModel = new PanelModel();
            $panelModel->update('1', $data);
            $message = array('message' => lang('Validation.updated'),'class' => 'success');
            session()->set('response_msg', $message);
            
        } else if ($this->request->getPost('app_submit') !== null) {
            
            $fields = [
                'isRTL', 'isMaintenance', 'isGoogleLogin', 'isLogin',
                'isScreenshot', 'isAPK','isVPN'
            ];
            
            $data = [];
            foreach ($fields as $field) {
                $data[$field] = !empty($this->request->getPost($field)) ? 'true' : 'false';
            }
            
            $panelModel = new PanelModel();
            $panelModel->update('1', $data);
            $message = array('message' => lang('Validation.updated'),'class' => 'success');
            session()->set('response_msg', $message);
            
        } else if ($this->request->getPost('api_submit') !== null) {
            
            $data = array(
                'home_limit'  =>  $this->request->getPost('home_limit'),
                'api_latest_limit'  =>  $this->request->getPost('api_latest_limit'),
                'api_cat_order_by'  =>  $this->request->getPost('api_cat_order_by'),
                'api_cat_post_order_by'  =>  $this->request->getPost('api_cat_post_order_by')
            );
            
            $panelModel = new PanelModel();
            $panelModel->update('1', $data);
            $message = array('message' => lang('Validation.updated'),'class' => 'success');
            session()->set('response_msg', $message);
            
        } else if ($this->request->getPost('policy_submit') !== null) {
            
            $data = array('app_privacy_policy'  =>  addslashes($this->request->getPost('app_privacy_policy')));
            
            $panelModel = new PanelModel();
            $panelModel->update('1', $data);
            $message = array('message' => lang('Validation.updated'),'class' => 'success');
            session()->set('response_msg', $message);
            
        } else if ($this->request->getPost('terms_submit') !== null) {
            
            $data = array('app_terms'  =>  addslashes($this->request->getPost('app_terms')));
            
            $panelModel = new PanelModel();
            $panelModel->update('1', $data);
            $message = array('message' => lang('Validation.updated'),'class' => 'success');
            session()->set('response_msg', $message);
            
        } else if ($this->request->getPost('notification_submit') !== null) {
            
            $data = array(
              'onesignal_app_id' => trim($this->request->getPost('onesignal_app_id')),
              'onesignal_rest_key' => trim($this->request->getPost('onesignal_rest_key')),
            );
            
            $panelModel = new PanelModel();
            $panelModel->update('1', $data);
            $message = array('message' => lang('Validation.updated'),'class' => 'success');
            session()->set('response_msg', $message);
            
        } else if ($this->request->getPost('app_update_submit') !== null) {
            
            $data = array(
                'app_update_status'  =>  ($this->request->getPost('app_update_status')) ? 'true' : 'false',
                'app_new_version'  =>  trim($this->request->getPost('app_new_version')),
                'app_update_desc'  =>  trim($this->request->getPost('app_update_desc')),
                'app_redirect_url'  =>  trim($this->request->getPost('app_redirect_url'))
            );
            
            $panelModel = new PanelModel();
            $panelModel->update('1', $data);
            $message = array('message' => lang('Validation.updated'),'class' => 'success');
            session()->set('response_msg', $message);
            
        } else if ($this->request->getPost('submit_more') !== null) {
            
            $data = array(
                'more_apps_url'  =>  trim($this->request->getPost('more_apps_url'))
            );
            
            $panelModel = new PanelModel();
            $panelModel->update('1', $data);
            $message = array('message' => lang('Validation.updated'),'class' => 'success');
            session()->set('response_msg', $message);
        }
        
        return redirect()->to(base_url('ns-admin/settings-app'));
    }
    
    // Settings WEB ------------------------------------------------------------
    public function web_index(){
        if(!CIAuth::check()){
            return redirect()->to(base_url('ns-admin/login'));
        }
        
        $allowedAdminTypes = [1, 3];
        if(!in_array(CIAuth::adminType(), $allowedAdminTypes)){
             return redirect()->to(base_url('ns-admin'));
        }
        
        $data = [
            'pageTitle' => 'Settings Web',
            'currentFile' => 'settings_web',
        ];
        
        $webModel = new WebModel();
        $data['settings_data'] = $webModel->getSettings();
        
        $sidebarModel = new SidebarModel();
        $data['result'] = $sidebarModel->orderBy('id', 'DESC')->findAll();
        
        $data['settings'] = $this->settings;
        return view('settings_web', $data);
    }
    
    public function webHandler(){
        if(!CIAuth::check()){
            return redirect()->to(base_url('ns-admin/login'));
        }
        
        $allowedAdminTypes = [1, 3];
        if(!in_array(CIAuth::adminType(), $allowedAdminTypes)){
             return redirect()->to(base_url('ns-admin'));
        }
        
        // Simple CSRF check with better error handling
        $postedToken = $this->request->getPost('csrf_test_name');
        if (empty($postedToken)) {
            $message = array('message' => 'CSRF token is missing. Please refresh the page and try again.', 'class' => 'error');
            session()->set('response_msg', $message);
            return redirect()->to(base_url('ns-admin/settings-web'));
        }
        if ($postedToken !== csrf_hash()) {
            $message = array('message' => 'Security token validation failed. Please refresh the page and try again.', 'class' => 'error');
            session()->set('response_msg', $message);
            return redirect()->to(base_url('ns-admin/settings-web'));
        }
        
        $webModel = new WebModel();
        $webData = $webModel->getSettings();
        
        if ($this->request->getPost('submit_general') !== null) {
            
            $imageNameFavicon = '';
            $file = $this->request->getFile('web_favicon');
            if ($file->isValid() && !$file->hasMoved()) {
                if ($webData['web_favicon']!="" && file_exists("images/{$webData['web_favicon']}")) {
                    unlink("images/{$webData['web_favicon']}");
                }
                $imageNameFavicon = $file->getRandomName();
                $file->move('images/', $imageNameFavicon);
            } else {
                $imageNameFavicon = $webData['web_favicon'];
            }
            
            $imageName = '';
            $file = $this->request->getFile('web_logo_1');
            if ($file->isValid() && !$file->hasMoved()) {
                if ($webData['web_logo_1']!="" && file_exists("images/{$webData['web_logo_1']}")) {
                    unlink("images/{$webData['web_logo_1']}");
                }
                $imageName = $file->getRandomName();
                $file->move('images/', $imageName);
            } else {
                $imageName = $webData['web_logo_1'];
            }
            
            $data = array(
                'site_name'  =>  $this->request->getPost('site_name'),
                'site_description'  =>  $this->request->getPost('site_description'),
                'site_keywords'  =>  $this->request->getPost('site_keywords'),
                'web_favicon'  =>  $imageNameFavicon,
                'web_logo_1'  =>  $imageName,
                'copyright_text'  =>  $this->request->getPost('copyright_text'),
                'header_code'  =>  htmlentities(trim($this->request->getPost('header_code'))),
                'footer_code'  => htmlentities(trim($this->request->getPost('footer_code')))
            );
            
            $webModel = new WebModel();
            $webModel->update('1', $data);
            $message = array('message' => lang('Validation.updated'),'class' => 'success');
            session()->set('response_msg', $message);
            
        } else if ($this->request->getPost('submit_privacy') !== null) {
            
            $data = array(
                'terms_of_use_page_title'  =>  $this->request->getPost('terms_of_use_page_title'),
                'terms_of_use_content'  =>  $this->request->getPost('terms_of_use_content')
            );
            
            $webModel = new WebModel();
            $webModel->update('1', $data);
            $message = array('message' => lang('Validation.updated'),'class' => 'success');
            session()->set('response_msg', $message);
            
        }  else if ($this->request->getPost('submit_terms') !== null) {
            
            $data = array(
                'privacy_page_title'  =>  $this->request->getPost('privacy_page_title'),
                'privacy_content'  =>  $this->request->getPost('privacy_content')
            );
            
            $webModel = new WebModel();
            $webModel->update('1', $data);
            $message = array('message' => lang('Validation.updated'),'class' => 'success');
            session()->set('response_msg', $message);
        } else if ($this->request->getPost('submit_about_us') !== null) {
            
            $data = array(
                'about_page_title'  =>  $this->request->getPost('about_page_title'),
                'about_content'  =>  $this->request->getPost('about_content')
            );
            
            $webModel = new WebModel();
            $webModel->update('1', $data);
            $message = array('message' => lang('Validation.updated'),'class' => 'success');
            session()->set('response_msg', $message);
        } else if ($this->request->getPost('submit_contact_us') !== null) {
            
            $data = array(
                'address'  =>  $this->request->getPost('address'),
                'contact_number'  =>  $this->request->getPost('contact_number'),
                'contact_email'  =>  $this->request->getPost('contact_email'),
                
                'android_app_url'  =>  $this->request->getPost('android_app_url'),
                'ios_app_url'  =>  $this->request->getPost('ios_app_url'),
                
                'facebook_url'  =>  $this->request->getPost('facebook_url'),
                'twitter_url'  =>  $this->request->getPost('twitter_url'),
                'youtube_url'  =>  $this->request->getPost('youtube_url'),
                'instagram_url'  =>  $this->request->getPost('instagram_url')
            );
            
            $webModel = new WebModel();
            $webModel->update('1', $data);
            $message = array('message' => lang('Validation.updated'),'class' => 'success');
            session()->set('response_msg', $message);
        }
        
        return redirect()->to(base_url('ns-admin/settings-web'));
    }
    
    // Settings Advertisement --------------------------------------------------
    public function ads_index(){
        if(!CIAuth::check()){
            return redirect()->to(base_url('ns-admin/login'));
        }
        
        $allowedAdminTypes = [1, 3];
        if(!in_array(CIAuth::adminType(), $allowedAdminTypes)){
             return redirect()->to(base_url('ns-admin'));
        }
        
        $data = [
            'pageTitle' => 'Settings Advertisement',
            'currentFile' => 'settings_ads',
        ];
        
        $data['settings'] = $this->settings;
        return view('settings_ads', $data);
    }
    
    public function advertisementHandler(){
        if(!CIAuth::check()){
            return redirect()->to(base_url('ns-admin/login'));
        }
        
        // Simple CSRF check with better error handling
        $postedToken = $this->request->getPost('csrf_test_name');
        if (empty($postedToken)) {
            $message = array('message' => 'CSRF token is missing. Please refresh the page and try again.', 'class' => 'error');
            session()->set('response_msg', $message);
            return redirect()->to(base_url('ns-admin/settings-ads'));
        }
        if ($postedToken !== csrf_hash()) {
            $message = array('message' => 'Security token validation failed. Please refresh the page and try again.', 'class' => 'error');
            session()->set('response_msg', $message);
            return redirect()->to(base_url('ns-admin/settings-ads'));
        }
        
        $ad_network = $this->request->getPost('ad_network');
        if($ad_network == 'admob'){
            
            $data = array(
                'ad_status'  =>  ($this->request->getPost('ad_status')) ? 'true' : 'false',
                'ad_network'  => $this->request->getPost('ad_network'),
                
                'admob_publisher_id'  =>  $this->request->getPost('admob_publisher_id'),
                'admob_banner_unit_id'  =>  $this->request->getPost('admob_banner_unit_id'),
                'admob_interstitial_unit_id'  =>  $this->request->getPost('admob_interstitial_unit_id'),
                'admob_native_unit_id'  =>  $this->request->getPost('admob_native_unit_id'),
                'admob_app_open_ad_unit_id'  =>  $this->request->getPost('admob_app_open_ad_unit_id'),
                'admob_reward_ad_unit_id'  =>  $this->request->getPost('admob_reward_ad_unit_id'),
                
                'interstital_ad_click'  =>  $this->request->getPost('interstital_ad_click'),
                'native_position'  =>  $this->request->getPost('native_position'),
                'reward_credit'  =>  $this->request->getPost('reward_credit'),
                
                'banner_home'  =>  ($this->request->getPost('banner_home')) ? 'true' : 'false',
                'banner_post_details'  =>  ($this->request->getPost('banner_post_details')) ? 'true' : 'false',
                'banner_category_details'  =>  ($this->request->getPost('banner_category_details')) ? 'true' : 'false',
                'banner_search'  =>  ($this->request->getPost('banner_search')) ? 'true' : 'false',
                
                'interstitial_post_list'  =>  ($this->request->getPost('interstitial_post_list')) ? 'true' : 'false',
                
                'native_ad_post_list'  =>  ($this->request->getPost('native_ad_post_list')) ? 'true' : 'false',
                'native_ad_category_list'  =>  ($this->request->getPost('native_ad_category_list')) ? 'true' : 'false',
                
                'app_open_ad_on_start'  => ($this->request->getPost('app_open_ad_on_start')) ? 'true' : 'false',
                'reward_ad_on'  => ($this->request->getPost('reward_ad_on')) ? 'true' : 'false',
            );
            $panelModel = new PanelModel();
            $panelModel->update('1', $data);
            
        } else if($ad_network == 'startapp'){
            
            $data = array(
                'ad_status'  =>  ($this->request->getPost('ad_status')) ? 'true' : 'false',
                'ad_network'  => $this->request->getPost('ad_network'),
                
                'startapp_app_id'  =>  $this->request->getPost('startapp_app_id'),
                
                'interstital_ad_click'  =>  $this->request->getPost('interstital_ad_click'),
                'native_position'  =>  $this->request->getPost('native_position'),
                'reward_credit'  =>  $this->request->getPost('reward_credit'),
                
                'banner_home'  =>  ($this->request->getPost('banner_home')) ? 'true' : 'false',
                'banner_post_details'  =>  ($this->request->getPost('banner_post_details')) ? 'true' : 'false',
                'banner_category_details'  =>  ($this->request->getPost('banner_category_details')) ? 'true' : 'false',
                'banner_search'  =>  ($this->request->getPost('banner_search')) ? 'true' : 'false',
                
                'interstitial_post_list'  =>  ($this->request->getPost('interstitial_post_list')) ? 'true' : 'false',
                
                'native_ad_post_list'  =>  ($this->request->getPost('native_ad_post_list')) ? 'true' : 'false',
                'native_ad_category_list'  =>  ($this->request->getPost('native_ad_category_list')) ? 'true' : 'false',
                
                'app_open_ad_on_start'  => ($this->request->getPost('app_open_ad_on_start')) ? 'true' : 'false',
                'reward_ad_on'  => ($this->request->getPost('reward_ad_on')) ? 'true' : 'false',
            );
            $panelModel = new PanelModel();
            $panelModel->update('1', $data);
            
        } else if($ad_network == 'unity'){
            
            $data = array(
                'ad_status'  =>  ($this->request->getPost('ad_status')) ? 'true' : 'false',
                'ad_network'  => $this->request->getPost('ad_network'),
                
                'unity_game_id'  =>  $this->request->getPost('unity_game_id'),
                'unity_banner_placement_id'  =>  $this->request->getPost('unity_banner_placement_id'),
                'unity_interstitial_placement_id'  =>  $this->request->getPost('unity_interstitial_placement_id'),
                'unity_reward_ad_unit_id'  =>  $this->request->getPost('unity_reward_ad_unit_id'),
                
                'interstital_ad_click'  =>  $this->request->getPost('interstital_ad_click'),
                'native_position'  =>  $this->request->getPost('native_position'),
                'reward_credit'  =>  $this->request->getPost('reward_credit'),
                
                'banner_home'  =>  ($this->request->getPost('banner_home')) ? 'true' : 'false',
                'banner_post_details'  =>  ($this->request->getPost('banner_post_details')) ? 'true' : 'false',
                'banner_category_details'  =>  ($this->request->getPost('banner_category_details')) ? 'true' : 'false',
                'banner_search'  =>  ($this->request->getPost('banner_search')) ? 'true' : 'false',
                
                'interstitial_post_list'  =>  ($this->request->getPost('interstitial_post_list')) ? 'true' : 'false',
                
                'native_ad_post_list'  =>  ($this->request->getPost('native_ad_post_list')) ? 'true' : 'false',
                'native_ad_category_list'  =>  ($this->request->getPost('native_ad_category_list')) ? 'true' : 'false',
                
                'app_open_ad_on_start'  => ($this->request->getPost('app_open_ad_on_start')) ? 'true' : 'false',
                'reward_ad_on'  => ($this->request->getPost('reward_ad_on')) ? 'true' : 'false',
            );
            $panelModel = new PanelModel();
            $panelModel->update('1', $data);
            
        } else if($ad_network == 'applovin'){
            
            $data = array(
                'ad_status'  =>  ($this->request->getPost('ad_status')) ? 'true' : 'false',
                'ad_network'  => $this->request->getPost('ad_network'),
                
                'applovin_banner_ad_unit_id'  =>  $this->request->getPost('applovin_banner_ad_unit_id'),
                'applovin_interstitial_ad_unit_id'  =>  $this->request->getPost('applovin_interstitial_ad_unit_id'),
                'applovin_native_ad_manual_unit_id'  =>  $this->request->getPost('applovin_native_ad_manual_unit_id'),
                'applovin_app_open_ad_unit_id'  =>  $this->request->getPost('applovin_app_open_ad_unit_id'),
                'applovin_reward_ad_unit_id'  =>  $this->request->getPost('applovin_reward_ad_unit_id'),
                
                'interstital_ad_click'  =>  $this->request->getPost('interstital_ad_click'),
                'native_position'  =>  $this->request->getPost('native_position'),
                'reward_credit'  =>  $this->request->getPost('reward_credit'),
                
                'banner_home'  =>  ($this->request->getPost('banner_home')) ? 'true' : 'false',
                'banner_post_details'  =>  ($this->request->getPost('banner_post_details')) ? 'true' : 'false',
                'banner_category_details'  =>  ($this->request->getPost('banner_category_details')) ? 'true' : 'false',
                'banner_search'  =>  ($this->request->getPost('banner_search')) ? 'true' : 'false',
                
                'interstitial_post_list'  =>  ($this->request->getPost('interstitial_post_list')) ? 'true' : 'false',
                
                'native_ad_post_list'  =>  ($this->request->getPost('native_ad_post_list')) ? 'true' : 'false',
                'native_ad_category_list'  =>  ($this->request->getPost('native_ad_category_list')) ? 'true' : 'false',
                
                'app_open_ad_on_start'  => ($this->request->getPost('app_open_ad_on_start')) ? 'true' : 'false',
                'reward_ad_on'  => ($this->request->getPost('reward_ad_on')) ? 'true' : 'false',
            );
            $panelModel = new PanelModel();
            $panelModel->update('1', $data);
            
        } else if($ad_network == 'ironsource'){
            
            $data = array(
                'ad_status'  =>  ($this->request->getPost('ad_status')) ? 'true' : 'false',
                'ad_network'  => $this->request->getPost('ad_network'),
                
                'ironsource_app_key'  =>  $this->request->getPost('ironsource_app_key'),
                
                'interstital_ad_click'  =>  $this->request->getPost('interstital_ad_click'),
                'native_position'  =>  $this->request->getPost('native_position'),
                'reward_credit'  =>  $this->request->getPost('reward_credit'),
                
                'banner_home'  =>  ($this->request->getPost('banner_home')) ? 'true' : 'false',
                'banner_post_details'  =>  ($this->request->getPost('banner_post_details')) ? 'true' : 'false',
                'banner_category_details'  =>  ($this->request->getPost('banner_category_details')) ? 'true' : 'false',
                'banner_search'  =>  ($this->request->getPost('banner_search')) ? 'true' : 'false',
                
                'interstitial_post_list'  =>  ($this->request->getPost('interstitial_post_list')) ? 'true' : 'false',
                
                'native_ad_post_list'  =>  ($this->request->getPost('native_ad_post_list')) ? 'true' : 'false',
                'native_ad_category_list'  =>  ($this->request->getPost('native_ad_category_list')) ? 'true' : 'false',
                
                'app_open_ad_on_start'  => ($this->request->getPost('app_open_ad_on_start')) ? 'true' : 'false',
                'reward_ad_on'  => ($this->request->getPost('reward_ad_on')) ? 'true' : 'false',
            );
            $panelModel = new PanelModel();
            $panelModel->update('1', $data);
            
        } else if($ad_network == 'meta'){
            
            $data = array(
                'ad_status'  =>  ($this->request->getPost('ad_status')) ? 'true' : 'false',
                'ad_network'  => $this->request->getPost('ad_network'),
                
                'mata_banner_ad_unit_id'  =>  $this->request->getPost('mata_banner_ad_unit_id'),
                'mata_interstitial_ad_unit_id'  =>  $this->request->getPost('mata_interstitial_ad_unit_id'),
                'mata_native_ad_manual_unit_id'  =>  $this->request->getPost('mata_native_ad_manual_unit_id'),
                
                'interstital_ad_click'  =>  $this->request->getPost('interstital_ad_click'),
                'native_position'  =>  $this->request->getPost('native_position'),
                'reward_credit'  =>  $this->request->getPost('reward_credit'),
                
                'banner_home'  =>  ($this->request->getPost('banner_home')) ? 'true' : 'false',
                'banner_post_details'  =>  ($this->request->getPost('banner_post_details')) ? 'true' : 'false',
                'banner_category_details'  =>  ($this->request->getPost('banner_category_details')) ? 'true' : 'false',
                'banner_search'  =>  ($this->request->getPost('banner_search')) ? 'true' : 'false',
                
                'interstitial_post_list'  =>  ($this->request->getPost('interstitial_post_list')) ? 'true' : 'false',
                
                'native_ad_post_list'  =>  ($this->request->getPost('native_ad_post_list')) ? 'true' : 'false',
                'native_ad_category_list'  =>  ($this->request->getPost('native_ad_category_list')) ? 'true' : 'false',
                
                'app_open_ad_on_start'  => ($this->request->getPost('app_open_ad_on_start')) ? 'true' : 'false',
                'reward_ad_on'  => ($this->request->getPost('reward_ad_on')) ? 'true' : 'false',
            );
            $panelModel = new PanelModel();
            $panelModel->update('1', $data);
            
        } else if($ad_network == 'yandex'){
            
            $data = array(
                'ad_status'  =>  ($this->request->getPost('ad_status')) ? 'true' : 'false',
                'ad_network'  => $this->request->getPost('ad_network'),
                
                'yandex_banner_ad_unit_id'  =>  $this->request->getPost('yandex_banner_ad_unit_id'),
                'yandex_interstitial_ad_unit_id'  =>  $this->request->getPost('yandex_interstitial_ad_unit_id'),
                'yandex_native_ad_manual_unit_id'  =>  $this->request->getPost('yandex_native_ad_manual_unit_id'),
                'yandex_app_open_ad_unit_id'  =>  $this->request->getPost('yandex_app_open_ad_unit_id'),
                
                'interstital_ad_click'  =>  $this->request->getPost('interstital_ad_click'),
                'native_position'  =>  $this->request->getPost('native_position'),
                'reward_credit'  =>  $this->request->getPost('reward_credit'),
                
                'banner_home'  =>  ($this->request->getPost('banner_home')) ? 'true' : 'false',
                'banner_post_details'  =>  ($this->request->getPost('banner_post_details')) ? 'true' : 'false',
                'banner_category_details'  =>  ($this->request->getPost('banner_category_details')) ? 'true' : 'false',
                'banner_search'  =>  ($this->request->getPost('banner_search')) ? 'true' : 'false',
                
                'interstitial_post_list'  =>  ($this->request->getPost('interstitial_post_list')) ? 'true' : 'false',
                
                'native_ad_post_list'  =>  ($this->request->getPost('native_ad_post_list')) ? 'true' : 'false',
                'native_ad_category_list'  =>  ($this->request->getPost('native_ad_category_list')) ? 'true' : 'false',
                
                'app_open_ad_on_start'  => ($this->request->getPost('app_open_ad_on_start')) ? 'true' : 'false',
                'reward_ad_on'  => ($this->request->getPost('reward_ad_on')) ? 'true' : 'false',
            );
            $panelModel = new PanelModel();
            $panelModel->update('1', $data);
            
        } else if($ad_network == 'wortise'){
            
            $data = array(
                'ad_status'  =>  ($this->request->getPost('ad_status')) ? 'true' : 'false',
                'ad_network'  => $this->request->getPost('ad_network'),
                
                'wortise_app_id'  =>  $this->request->getPost('wortise_app_id'),
                'wortise_banner_unit_id'  =>  $this->request->getPost('wortise_banner_unit_id'),
                'wortise_interstitial_unit_id'  =>  $this->request->getPost('wortise_interstitial_unit_id'),
                'wortise_native_unit_id'  =>  $this->request->getPost('wortise_native_unit_id'),
                'wortise_app_open_unit_id'  =>  $this->request->getPost('wortise_app_open_unit_id'),
                'wortise_reward_ad_unit_id'  =>  $this->request->getPost('wortise_reward_ad_unit_id'),
                
                'interstital_ad_click'  =>  $this->request->getPost('interstital_ad_click'),
                'native_position'  =>  $this->request->getPost('native_position'),
                'reward_credit'  =>  $this->request->getPost('reward_credit'),
                
                'banner_home'  =>  ($this->request->getPost('banner_home')) ? 'true' : 'false',
                'banner_post_details'  =>  ($this->request->getPost('banner_post_details')) ? 'true' : 'false',
                'banner_category_details'  =>  ($this->request->getPost('banner_category_details')) ? 'true' : 'false',
                'banner_search'  =>  ($this->request->getPost('banner_search')) ? 'true' : 'false',
                
                'interstitial_post_list'  =>  ($this->request->getPost('interstitial_post_list')) ? 'true' : 'false',
                
                'native_ad_post_list'  =>  ($this->request->getPost('native_ad_post_list')) ? 'true' : 'false',
                'native_ad_category_list'  =>  ($this->request->getPost('native_ad_category_list')) ? 'true' : 'false',
                
                'app_open_ad_on_start'  => ($this->request->getPost('app_open_ad_on_start')) ? 'true' : 'false',
                'reward_ad_on'  => ($this->request->getPost('reward_ad_on')) ? 'true' : 'false',
            );
            $panelModel = new PanelModel();
            $panelModel->update('1', $data);
            
        } else {
            
            $data = array(
                'ad_status'  =>  ($this->request->getPost('ad_status')) ? 'true' : 'false',
                'ad_network'  => $this->request->getPost('ad_network'),
                
                'interstital_ad_click'  =>  $this->request->getPost('interstital_ad_click'),
                'native_position'  =>  $this->request->getPost('native_position'),
                'reward_credit'  =>  $this->request->getPost('reward_credit'),
                
                'banner_home'  =>  ($this->request->getPost('banner_home')) ? 'true' : 'false',
                'banner_post_details'  =>  ($this->request->getPost('banner_post_details')) ? 'true' : 'false',
                'banner_category_details'  =>  ($this->request->getPost('banner_category_details')) ? 'true' : 'false',
                'banner_search'  =>  ($this->request->getPost('banner_search')) ? 'true' : 'false',
                
                'interstitial_post_list'  =>  ($this->request->getPost('interstitial_post_list')) ? 'true' : 'false',
                
                'native_ad_post_list'  =>  ($this->request->getPost('native_ad_post_list')) ? 'true' : 'false',
                'native_ad_category_list'  =>  ($this->request->getPost('native_ad_category_list')) ? 'true' : 'false',
                
                'app_open_ad_on_start'  => ($this->request->getPost('app_open_ad_on_start')) ? 'true' : 'false',
                'reward_ad_on'  => ($this->request->getPost('reward_ad_on')) ? 'true' : 'false',
            );
            
            $panelModel = new PanelModel();
            $panelModel->update('1', $data);
        }
        $message = array('message' => lang('Validation.updated'),'class' => 'success');
        session()->set('response_msg', $message);
        return redirect()->to(base_url('ns-admin/settings-ads'));
    }
    
    public function getBooleanPostValue($field){
        return ($this->request->getPost($field)) ? 'true' : 'false';
    }
    
    private function handleImageUploadAdmin($existingImage = '') {
    $suffix = '_admin';
        $file = $this->request->getFile('app_logo');
        
        // Check if the file exists
        if (!$file) {
            return $existingImage; // Return the existing image if no file was uploaded
        }
        
        if ($file->isValid() && !$file->hasMoved()) {
            
            // Validate file type (only images allowed)
            if (!in_array($file->getMimeType(), ['image/jpeg', 'image/png', 'image/gif', 'image/svg+xml','image/webp', 'image/heic', 'image/heif'])) {
                return $existingImage; // Return existing image if the file is not an image
            }
            
            $imageDirectory = 'images/';
            
            // Check if the directory exists; if not, create it
            if (!is_dir($imageDirectory)) {
                mkdir($imageDirectory, 0755, true); // Create directory with safer permissions
            }
            
            // Delete existing image if it exists
            if ($existingImage && file_exists($imageDirectory . $existingImage)) {
                unlink($imageDirectory . $existingImage);
            }
            
            // Generate new image name with a suffix
            $extension = $file->getExtension(); // Get file extension
            $imageName = rand(0, 99999) . $suffix . '.' . $extension; // Append suffix
            
            // Move the file with the new name
            $file->move($imageDirectory, $imageName);
            
            return $imageName;
        }
        return $existingImage;
   }
}